<?php
/**
 * 2007-2020 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 *
 *
 * @author    Hervé Hennes <contact@h-hennes.fr>
 * @copyright 2007-2020
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *
 * @generated by PrestashopConsole  / copyright 2016-2020 Hennes Hervé http://www.h-hennes.fr/blog/
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

use Symfony\Component\Filesystem\Filesystem;

class Hh_Modulesupdater extends Module
{

    public function __construct()
    {
        $this->name = 'hh_modulesupdater';
        $this->tab = 'others';
        $this->version = '0.1.0';
        $this->author = 'hhennes';
        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = $this->l('Manage module update button');
        $this->description = $this->l('Enable or disable update modules button in admin');
    }

    /**
     * Install Module
     * @return bool
     */
    public function install()
    {
        if (
            !parent::install()
            || !Configuration::updateGlobalValue($this->name . '_ENABLE_MODULES_UPDATE', 0)

        ) {
            return false;
        }

        return true;
    }

    /**
     * Uninstall Module
     * @return bool
     */
    public function uninstall()
    {
        return parent::uninstall() && Configuration::deleteByName($this->name . '_ENABLE_MODULES_UPDATE');
    }

    /**
     * Configure module
     * @return string
     */
    public function getContent()
    {
        $html = '';
        $html .= $this->postProcess();
        $html .= $this->renderForm();

        return $html;
    }

    /**
     * Manage configuration upgrade
     * @return string|void
     */
    protected function postProcess()
    {
        if (Tools::isSubmit('SubmitConfigForm')) {
            $enableUpdate = Tools::getValue($this->name . '_ENABLE_MODULES_UPDATE');
            if (Configuration::updateValue(
                    $this->name . '_ENABLE_MODULES_UPDATE',
                    $enableUpdate
                ) && $this->toggleModuleUpdate((bool)$enableUpdate)) {
                return $this->displayConfirmation($this->l('Settings Updated'));
            } else {
                return $this->displayError($this->l('Unable to update settings'));
            }
        }
    }

    /**
     * Get configuration form
     * @return string
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    protected function renderForm()
    {
        $fields_form = [
            'form' => [
                'legend' => [
                    'title' => $this->l('Configure module upgrade'),
                    'icon' => 'icon-cogs'
                ],
                'input' => [
                    [
                        'type' => 'switch',
                        'label' => $this->l('Enable module Upgrade'),
                        'name' => $this->name . '_ENABLE_MODULES_UPDATE',
                        'hint' => $this->l('Allow to upgrade modules from back office ? (disabled by default by this module)'),
                        'required' => true,
                        'values' => [
                            ['id' => 'on', 'value' => 1, 'label' => $this->l('Yes')],
                            ['id' => 'off', 'value' => 0, 'label' => $this->l('No')],
                        ],
                    ],
                ],
                'submit' => [
                    'title' => $this->l('Save'),
                    'class' => 'button btn btn-default pull-right',
                ]
            ],
        ];

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $lang->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $helper->identifier = $this->name;
        $helper->submit_action = 'SubmitConfigForm';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => [
                $this->name . '_ENABLE_MODULES_UPDATE' => Tools::getValue($this->name . '_ENABLE_MODULES_UPDATE', 0),
            ],
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );

        return $helper->generateForm(array($fields_form));
    }

    /**
     * Toggle Module Update by changing template name
     * @param bool $enable
     * @return bool
     */
    protected function toggleModuleUpdate($enable)
    {
        $fileSystem = new Filesystem();
        $updagradeTemplatePath = _PS_MODULE_DIR_ . $this->name . '/views/PrestaShop/Admin/Module/Includes/';
        if (true === $enable && $fileSystem->exists($updagradeTemplatePath . 'action_button.html.twig')) {
            try {
                $fileSystem->rename(
                    $updagradeTemplatePath . 'action_button.html.twig',
                    $updagradeTemplatePath . 'action_button.html.twig.disabled'
                );
                return true;
            } catch (Exception $e) {
                return false;
            }
        }

        if (false === $enable && $fileSystem->exists($updagradeTemplatePath . 'action_button.html.twig.disabled')) {
            try {
                $fileSystem->rename(
                    $updagradeTemplatePath . 'action_button.html.twig.disabled',
                    $updagradeTemplatePath . 'action_button.html.twig'
                );
                return true;
            } catch (Exception $e) {
                return false;
            }
        }

        return false;
    }
}
